/* ------- */
/* qhead.h */
/* ------- */
# ifndef __QHEAD_H__
# 	define	__QHEAD_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Type of the array elements in a Q-type number */
typedef short QELT;

/* Number of bits in a word of that type */
#define WORDSIZE 16

/* Number of WORDSIZE-bit words in a q type number.
   For WORDSIZE 16, NQ = 12 or 24.
   For WORDSIZE 32, NQ = 14.  */
#define NQ 24

/* Most significant bit of the word size used.  */
#define SIGNBIT ((unsigned int) 1 << (WORDSIZE-1))

/* Largest exponent value */
#define MAXEXP 32767

/* The exponent of 1.0 */
#define EXPONE 0x4001

/* Number of words in significand area */
#define OMG (NQ-2)

/* Byte offset to least significant word of significand */
#define OFFS (4*OMG+4)

/* Number of bits of precision */
#define NBITS ((OMG-1)*WORDSIZE)

/* Maximum number of decimal digits after decimal point in conversion */
#define NDEC (NBITS*8/27)

typedef struct QCmplxStru
	{
	QELT r[NQ];
	QELT i[NQ];
	}qcmplx;

extern short oneopi[];
extern short q32[];
extern short qeul[];
extern short qhalf[];
extern short qlog2[];
extern short qnine[];
extern short qone[];
extern short qpi[];
extern short qsqrt2[];
extern short qthree[];
extern short qtwo[];
extern short qzero[];
#if 0
/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */

/* INDENT OFF */

extern	int	addm	(void *, void *);
extern	int	asctoq	(char *, void *);
extern	int	cmpm	(void *, void *);
extern	int	divm	(void *, void *);
extern	int	dtoq	(void *, void *);
extern	int	e113toq	(void *, void *);
extern	int	e64toq	(void *, void *);
extern	int	etoq	(void *, void *);
extern	int	ltoq	(long *, void *);
extern	int	mtherr	(const char *, int);
extern	int	mulin	(void *, void *);
extern	int	mulm	(void *, void *);
extern	int	normlz	(void *);
extern	int	qabs	(void *);
extern	int	qadd	(void *, void *, void *);
extern	int	qadd1	(void *, void *, void *);
extern	int	qclear	(void *);
extern	int	qcmp	(void *, void *);
extern	int	qdiv	(void *, void *, void *);
extern	int	qexp	(void *, void *);
extern	int	qfloor	(void *, void *);
extern	int	qifrac	(void *, long *, void *);
extern	int	qinfin	(void *);
extern	int	qisneg	(void *);
extern	int	qldexp	(void *, int);
extern	int	qlog	(void *, void *);
extern	int	qmov	(void *, void *);
extern	int	qmovz	(void *, void *);
extern	int	qmul	(void *, void *, void *);
extern	int	qmuli	(void *, void *, void *);
extern	int	qneg	(void *);
extern	int	qnrmlz	(void *);
extern	int	qpow	(void *, void *, void *);
extern	int	qpowi	(void *, void *, void *);
extern	int	qrand	(void *);
extern	int	qremain	(void *, void *, void *);
extern	int	qround	(void *, void *);
extern	int	qsqrt	(void *, void *);
//extern	void	qsrand	(const unsigned int);
extern	int	qsub	(void *, void *, void *);
extern	int	qtanh	(void *, void *);
extern	int	qtoasc	(void *, char *, int);
extern	int	qtod	(void *, void *);
extern	int	qtoe	(void *, void *);
extern	int	qtoe113	(void *, void *);
extern	int	qtoe64	(void *, void *);
extern	int	shdn1	(void *);
extern	int	shdn16	(void *);
extern	int	shdn8	(void *);
extern	int	shift	(void *);
extern	int	shup1	(void *);
extern	int	shup16	(void *);
extern	int	shup8	(void *);
extern	int	subm	(void *, void *);

# undef	F
/* INDENT ON */
#endif
#ifdef __cplusplus
}
#endif

# endif
